// Creado por Dh Cast basado en los ejemplos de la pagina oficial de arduino.
// Sígueme en youtube como DH Cast en: https://www.youtube.com/channel/UCEDc4fUdM2huFe77U5SeDVQ/?sub_confirmation=1
// Espero te sea de ayuda, si lo fué regálame un buen like y suscríbete.
// También puedes dejar un comentario sobre que proyecto te gustaría ver en el canal.

const int data=7; // Pin de datos, se conecta sólo al último integrado.
const int latch=6; // Pin latch
const int clockPin=5; // Pin de reloj

void setup() {
  pinMode(data,OUTPUT); // Configuro los pines como salida.
  pinMode(latch,OUTPUT);
  pinMode(clockPin,OUTPUT);
}

void loop() {
  boolean SR1[8]= {1,0,1,0,1,0,1,0}; // Arreglo de estados del primer integrado
  // Si quieres editar este arreglo en otra parte del código, Sólo seria utilizar "SR1[Posición]= 1" ó "SR1[Posición]= 0" donde la posición es un número del 
  // 0 al 7 que corresponden a las salidas desde la A a la H de dicho integrado.
  boolean SR2[8]= {1,1,1,1,0,0,0,0}; // Lo mismo que con el uno pero con un dos en el nombre.
  digitalWrite(latch, LOW);// Predeterminado, protocolo de comunicación.
  shiftOut(data, clockPin,LSBFIRST, convertir(SR1)); // Función para enviar datos al integrado.
  
  shiftOut(data, clockPin,LSBFIRST, convertir(SR2)); // 
  digitalWrite(latch,HIGH); //Predeterminado
  delay(1000); // Un tiempo de espera que puede ser cualquiera en milisegundos.

}
uint8_t convertir(boolean arreglo[]){ // Función  para convertir arreglo a variable del tipo uint8_t de 8 bits
  uint8_t val=B00000000; // inicio la variable que se devolverá con todos sus bits en 0, para eso utilizo la letra B al inicio.
  for(int i=0; i<8; i++){ // Un ciclo for como cualquier otro ciclo for que recorre el arreglo de 8 posiciones.
    val=val<<1;  // Muevo los bits hacia la izquierda, para mas referencias del operador, revisar la pagina oficial de arduino.
    if(arreglo[i]==HIGH){ // condición que suma un uno al final de la variable val, en caso de que sea uno. Si es cero no hace nada.
      val=val+B1;
    }
  }
  return val; // Típica variable de retorno, si no para que creamos la función.
}
