//Creado por DH Cast
//Sígueme en Youtube como: Dh Cast en https://www.youtube.com/channel/UCEDc4fUdM2huFe77U5SeDVQ/?sub_confirmation=1
//Sígueme en Patron como: Cast en https://www.patreon.com/dhcast
// Espero ser de ayuda y suerte en tus proyectos!!

#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
 #include <avr/power.h> // Required for 16 MHz Adafruit Trinket
#endif

#define PIN        6 // pin para datos.

#define NUMPIXELS 300 // Número de pixeles con los que se trabaja.

// When setting up the NeoPixel library, we tell it how many pixels,
// and which pin to use to send signals. Note that for older NeoPixel
// strips you might need to change the third parameter -- see the
// strandtest example for more information on possible values.
Adafruit_NeoPixel pixels(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

#define DELAYVAL 100 // Time (in milliseconds) to pause between pixels
// En caso de que se quiera usar.

void setup() {
  // These lines are specifically to support the Adafruit Trinket 5V 16 MHz.
  // Any other board, you can remove this part (but no harm leaving it):
#if defined(__AVR_ATtiny85__) && (F_CPU == 16000000)
  clock_prescale_set(clock_div_1);
#endif
  // END of Trinket-specific code.

  pixels.begin(); // INITIALIZE NeoPixel strip object (REQUIRED)
}

void loop() {
  pixels.clear(); // Apagar todos los pixeles
  for(int i=0;i<NUMPIXELS; i++){ // Un ciclo for normal que recorre cada uno de los pixeles
    pixels.setPixelColor( i,pixels.Color( 255, 0, 255));  // Edita el color de un pixel, con la función color se establece los valores de los led Red Green y Blue.

    int pixelAnterior= i-1;  // Variable para apagar el led anterior.
    if(pixelAnterior < 0){ 
      pixelAnterior= 299;
    }
    pixels.setPixelColor( pixelAnterior,pixels.Color( 0, 0, 0)); //Apaga el led encendido anterior al actual
    pixels.show(); //Muestra cada uno de los cambios anteriores realizados.
    delay(10); // Espera de 10 milisegundos para visualizar los resultados en la tira led correctamente.
  }
}
