//Creado por DH Cast
//Síguemnos en Youtube como: Dh Cast en https://www.youtube.com/channel/UCEDc4fUdM2huFe77U5SeDVQ/?sub_confirmation=1
//Síguenos en nuestro sitio web como: Cast en https://dhcast.net/
// Espero ser de ayuda y suerte en tus proyectos!!

#include "thingProperties.h"
#include <Adafruit_NeoPixel.h>

#define PIN 48
#define NUMPIXELS 60
Adafruit_NeoPixel pixels(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);
#define DELAYVAL 1

int counterMainReconnect = 0;
void HSLtoRGB(float hue, float sat, float light, uint8_t &r, uint8_t &g, uint8_t &b);

void setup() {
  pixels.begin();
  Serial.begin(9600);

  for(unsigned long const serialBeginTime = millis(); !Serial && (millis() - serialBeginTime <= 5000); ){}
  setDebugMessageLevel(DBG_INFO);

  initProperties();

  ArduinoCloud.begin(ArduinoIoTPreferredConnection);

  ArduinoCloud.printDebugInfo();
}

void loop() {
  if(counterMainReconnect > 300){
    if(!ArduinoCloud.connected()){
      Serial.println("Reconnect Arduino IoT");
      ArduinoCloud.begin(ArduinoIoTPreferredConnection);
    }
    ArduinoCloud.update();
  }else{
    ArduinoCloud.update();
    counterMainReconnect++;
    delay(100);
  }
}

void HSLtoRGB(float hue, float sat, float light, uint8_t &r, uint8_t &g, uint8_t &b){
  float c = (1- abs(2 * light -1)) * sat;
  float x = c * (1 - abs(fmod(hue / 60.0, 2) - 1));
  float m = light -c / 2;

  float rPrime, gPrime, bPrime;

  if (hue >= 0 && hue < 60) {
      rPrime = c; gPrime = x; bPrime = 0;
  } else if (hue >= 60 && hue < 120) {
      rPrime = x; gPrime = c; bPrime = 0;
  } else if (hue >= 120 && hue < 180) {
      rPrime = 0; gPrime = c; bPrime = x;
  } else if (hue >= 180 && hue < 240) {
      rPrime = 0; gPrime = x; bPrime = c;
  } else if (hue >= 240 && hue < 300) {
      rPrime = x; gPrime = 0; bPrime = c;
  } else {
      rPrime = c; gPrime = 0; bPrime = x;
  }

  r = (rPrime + m) * 255;
  g = (gPrime + m) * 255;
  b = (bPrime + m) * 255;
}

void onDHCastThingChange(){
  uint8_t r=0, g=0, b=0;

  HSLtoRGB(dHCastThing.getHue(), dHCastThing.getSaturation()/100, 0.5, r, g, b);
  Serial.printf("\nDatos RGB: R = %d, G = %d, B = %d, Switch = %d, Brightness = %d", r , g , b, dHCastThing.getSwitch() , dHCastThing.getBrightness());

  pixels.clear();

  if(dHCastThing.getSwitch() == 1){
    for(int i = 0 ; i<NUMPIXELS ; i++){
      pixels.setPixelColor(i, pixels.Color(r, g, b));
      pixels.show();
      delay(DELAYVAL);
    }
  }else{
    pixels.show();
  }
}



